/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WTextField
extends WWidget {
    public static final int TEXT_PADDING_X = 4;
    public static final int TEXT_PADDING_Y = 6;
    public static final int CURSOR_PADDING_Y = 4;
    public static final int CURSOR_HEIGHT = 12;
    @Environment(value=EnvType.CLIENT)
    private class_327 font;
    private String text = "";
    private int maxLength = 16;
    private boolean editable = true;
    private int tickCount = 0;
    private int disabledColor = 0x707070;
    private int enabledColor = 0xE0E0E0;
    private int suggestionColor = 0x808080;
    private static final int BACKGROUND_COLOR = -16777216;
    private static final int BORDER_COLOR_SELECTED = -96;
    private static final int BORDER_COLOR_UNSELECTED = -6250336;
    private static final int CURSOR_COLOR = -3092272;
    @Nullable
    private class_2561 suggestion = null;
    private int scrollOffset = 0;
    private int cursor = 0;
    private int select = -1;
    private Consumer<String> onChanged;
    private Predicate<String> textPredicate;
    @Environment(value=EnvType.CLIENT)
    @Nullable
    private BackgroundPainter backgroundPainter;

    public WTextField() {
    }

    public WTextField(class_2561 suggestion) {
        this.suggestion = suggestion;
    }

    public void setText(String s) {
        this.setTextWithResult(s);
    }

    private boolean setTextWithResult(String s) {
        if (this.textPredicate == null || this.textPredicate.test(s)) {
            String string = this.text = s.length() > this.maxLength ? s.substring(0, this.maxLength) : s;
            if (this.onChanged != null) {
                this.onChanged.accept(this.text);
            }
            if (this.cursor >= this.text.length()) {
                this.cursor = this.text.length() - 1;
            }
            return true;
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.tickCount;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, 20);
    }

    public void setCursorPos(int location) {
        this.cursor = class_3532.method_15340((int)location, (int)0, (int)this.text.length());
        this.scrollCursorIntoView();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getCursor() {
        return this.cursor;
    }

    @Environment(value=EnvType.CLIENT)
    public void scrollCursorIntoView() {
        if (this.scrollOffset > this.cursor) {
            this.scrollOffset = this.cursor;
        }
        if (this.scrollOffset < this.cursor && this.font.method_27523(this.text.substring(this.scrollOffset), this.width - 8).length() + this.scrollOffset < this.cursor) {
            this.scrollOffset = this.cursor;
        }
        this.checkScrollOffset();
    }

    @Environment(value=EnvType.CLIENT)
    private void checkScrollOffset() {
        int rightMostScrollOffset = this.text.length() - this.font.method_27524(this.text, this.width - 8, true).length();
        this.scrollOffset = Math.min(rightMostScrollOffset, this.scrollOffset);
    }

    @Nullable
    public String getSelection() {
        if (this.select < 0) {
            return null;
        }
        if (this.select == this.cursor) {
            return null;
        }
        if (this.select > this.text.length()) {
            this.select = this.text.length();
        }
        if (this.cursor < 0) {
            this.cursor = 0;
        }
        if (this.cursor > this.text.length()) {
            this.cursor = this.text.length();
        }
        int start = Math.min(this.select, this.cursor);
        int end = Math.max(this.select, this.cursor);
        return this.text.substring(start, end);
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderBox(class_4587 matrices, int x, int y) {
        int borderColor = this.isFocused() ? -96 : -6250336;
        ScreenDrawing.coloredRect(matrices, x - 1, y - 1, this.width + 2, this.height + 2, borderColor);
        ScreenDrawing.coloredRect(matrices, x, y, this.width, this.height, -16777216);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderText(class_4587 matrices, int x, int y, String visibleText) {
        int textColor = this.editable ? this.enabledColor : this.disabledColor;
        this.font.method_1720(matrices, visibleText, (float)(x + 4), (float)(y + 6), textColor);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderCursor(class_4587 matrices, int x, int y, String visibleText) {
        if (this.tickCount / 6 % 2 == 0) {
            return;
        }
        if (this.cursor < this.scrollOffset) {
            return;
        }
        if (this.cursor > this.scrollOffset + visibleText.length()) {
            return;
        }
        int cursorOffset = this.font.method_1727(visibleText.substring(0, this.cursor - this.scrollOffset));
        ScreenDrawing.coloredRect(matrices, x + 4 + cursorOffset, y + 4, 1, 12, -3092272);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderSuggestion(class_4587 matrices, int x, int y) {
        if (this.suggestion == null) {
            return;
        }
        this.font.method_30881(matrices, this.suggestion, (float)(x + 4), (float)(y + 6), this.suggestionColor);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderSelection(class_4587 matrices, int x, int y, String visibleText) {
        if (this.select == this.cursor || this.select == -1) {
            return;
        }
        int textLength = visibleText.length();
        int left = Math.min(this.cursor, this.select);
        int right = Math.max(this.cursor, this.select);
        if (right < this.scrollOffset || left > this.scrollOffset + textLength) {
            return;
        }
        int normalizedLeft = Math.max(this.scrollOffset, left) - this.scrollOffset;
        int normalizedRight = Math.min(this.scrollOffset + textLength, right) - this.scrollOffset;
        int leftCaret = this.font.method_1727(visibleText.substring(0, normalizedLeft));
        int selectionWidth = this.font.method_1727(visibleText.substring(normalizedLeft, normalizedRight));
        this.invertedRect(matrices, x + 4 + leftCaret, y + 4, selectionWidth, 12);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderTextField(class_4587 matrices, int x, int y) {
        if (this.font == null) {
            this.font = class_310.method_1551().field_1772;
        }
        this.checkScrollOffset();
        String visibleText = this.font.method_27523(this.text.substring(this.scrollOffset), this.width - 8);
        this.renderBox(matrices, x, y);
        this.renderText(matrices, x, y, visibleText);
        if (this.text.isEmpty() && !this.isFocused()) {
            this.renderSuggestion(matrices, x, y);
        }
        if (this.isFocused()) {
            this.renderCursor(matrices, x, y, visibleText);
        }
        this.renderSelection(matrices, x, y, visibleText);
    }

    @Environment(value=EnvType.CLIENT)
    private void invertedRect(class_4587 matrices, int x, int y, int width, int height) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        class_1159 model = matrices.method_23760().method_23761();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        buffer.method_22918(model, (float)x, (float)(y + height), 0.0f).method_1344();
        buffer.method_22918(model, (float)(x + width), (float)(y + height), 0.0f).method_1344();
        buffer.method_22918(model, (float)(x + width), (float)y, 0.0f).method_1344();
        buffer.method_22918(model, (float)x, (float)y, 0.0f).method_1344();
        buffer.method_1326();
        class_286.method_1309((class_287)buffer);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public WTextField setTextPredicate(Predicate<String> predicate_1) {
        this.textPredicate = predicate_1;
        return this;
    }

    public WTextField setChangedListener(Consumer<String> listener) {
        this.onChanged = listener;
        return this;
    }

    public WTextField setMaxLength(int max) {
        this.maxLength = max;
        if (this.text.length() > max) {
            this.setText(this.text.substring(0, max));
        }
        return this;
    }

    public WTextField setEnabledColor(int col) {
        this.enabledColor = col;
        return this;
    }

    public WTextField setSuggestionColor(int suggestionColor) {
        this.suggestionColor = suggestionColor;
        return this;
    }

    public WTextField setDisabledColor(int col) {
        this.disabledColor = col;
        return this;
    }

    public WTextField setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    @Nullable
    public class_2561 getSuggestion() {
        return this.suggestion;
    }

    @Deprecated(forRemoval=true, since="5.4.0")
    @ApiStatus.ScheduledForRemoval(inVersion="6.0.0")
    public WTextField setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion != null ? new class_2585(suggestion) : null;
        return this;
    }

    public WTextField setSuggestion(@Nullable class_2561 suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public WTextField setBackgroundPainter(BackgroundPainter painter) {
        this.backgroundPainter = painter;
        return this;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public void onFocusGained() {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        this.renderTextField(matrices, x, y);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(int x, int y, int button) {
        this.requestFocus();
        this.cursor = this.getCaretPosition(x - 4);
        this.scrollCursorIntoView();
        return InputResult.PROCESSED;
    }

    @Environment(value=EnvType.CLIENT)
    public int getCaretPosition(int clickX) {
        if (clickX < 0) {
            return 0;
        }
        int lastPos = 0;
        this.checkScrollOffset();
        String string = this.text.substring(this.scrollOffset);
        for (int i = 0; i < string.length(); ++i) {
            int w = this.font.method_1727("" + string.charAt(i));
            if (lastPos + w >= clickX && clickX - lastPos < w / 2) {
                return i + this.scrollOffset;
            }
            lastPos += w;
        }
        return string.length();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onCharTyped(char ch) {
        this.insertText("" + ch);
    }

    @Environment(value=EnvType.CLIENT)
    private void insertText(String toInsert) {
        String after;
        String before;
        if (this.select != -1 && this.select != this.cursor) {
            int left = Math.min(this.cursor, this.select);
            int right = Math.max(this.cursor, this.select);
            before = this.text.substring(0, left);
            after = this.text.substring(right);
        } else {
            before = this.text.substring(0, this.cursor);
            after = this.text.substring(this.cursor);
        }
        if (before.length() + after.length() + toInsert.length() > this.maxLength) {
            return;
        }
        if (this.setTextWithResult(before + toInsert + after)) {
            this.select = -1;
            this.cursor = (before + toInsert).length();
            this.scrollCursorIntoView();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void copySelection() {
        String selection = this.getSelection();
        if (selection != null) {
            class_310.method_1551().field_1774.method_1455(selection);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void paste() {
        String clip = class_310.method_1551().field_1774.method_1460();
        this.insertText(clip);
    }

    @Environment(value=EnvType.CLIENT)
    private void deleteSelection() {
        int left = Math.min(this.cursor, this.select);
        int right = Math.max(this.cursor, this.select);
        if (this.setTextWithResult(this.text.substring(0, left) + this.text.substring(right))) {
            this.select = -1;
            this.cursor = left;
            this.scrollCursorIntoView();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void delete(int modifiers, boolean backwards) {
        if (this.select == -1 || this.select == this.cursor) {
            this.select = this.skipCharaters((2 & modifiers) != 0, backwards ? -1 : 1);
        }
        this.deleteSelection();
    }

    @Environment(value=EnvType.CLIENT)
    private int skipCharaters(boolean skipMany, int direction) {
        if (direction != -1 && direction != 1) {
            return this.cursor;
        }
        int position = this.cursor;
        do {
            if ((position += direction) < 0) {
                return 0;
            }
            if (position > this.text.length()) {
                return this.text.length();
            }
            if (skipMany) continue;
            return position;
        } while (position >= this.text.length() || !Character.isWhitespace(this.text.charAt(position)));
        return position;
    }

    @Environment(value=EnvType.CLIENT)
    public void onDirectionalKey(int direction, int modifiers) {
        if ((1 & modifiers) != 0) {
            if (this.select == -1 || this.select == this.cursor) {
                this.select = this.cursor;
            }
            this.cursor = this.skipCharaters((2 & modifiers) != 0, direction);
        } else if (this.select != -1) {
            this.cursor = direction < 0 ? Math.min(this.cursor, this.select) : Math.max(this.cursor, this.select);
            this.select = -1;
        } else {
            this.cursor = this.skipCharaters((2 & modifiers) != 0, direction);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onKeyPressed(int ch, int key, int modifiers) {
        if (!this.isEditable()) {
            return;
        }
        if (class_437.method_25438((int)ch)) {
            this.copySelection();
            return;
        }
        if (class_437.method_25437((int)ch)) {
            this.paste();
            return;
        }
        if (class_437.method_25439((int)ch)) {
            this.select = 0;
            this.cursor = this.text.length();
            return;
        }
        switch (ch) {
            case 261: {
                this.delete(modifiers, false);
                break;
            }
            case 259: {
                this.delete(modifiers, true);
                break;
            }
            case 263: {
                this.onDirectionalKey(-1, modifiers);
                break;
            }
            case 262: {
                this.onDirectionalKey(1, modifiers);
                break;
            }
            case 265: 
            case 268: {
                if ((1 & modifiers) == 0) {
                    this.select = -1;
                }
                this.cursor = 0;
                break;
            }
            case 264: 
            case 269: {
                if ((1 & modifiers) == 0) {
                    this.select = -1;
                }
                this.cursor = this.text.length();
            }
        }
        this.scrollCursorIntoView();
    }

    @Override
    public void addNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)new class_2588("widget.libgui.text_field.narration.title", new Object[]{this.text}));
        if (this.suggestion != null) {
            builder.method_37034(class_6381.field_33790, (class_2561)new class_2588("widget.libgui.text_field.narration.suggestion", new Object[]{this.suggestion}));
        }
    }
}

